 ; Ŀ
 ;   Tray - draw a cable tray elbow.                                       
 ;   Copyright 1997 by Rocket Software                                     
 ;                                                                         
 ; 

 ; Ŀ
 ;   Terror - an error handler.                                            
 ; 
 (DEFUN TERROR (shk /)
  (if pasav (c2 pasav radd widd))
  (print shk)
  (setq *error* esav)
 (princ))
 ; Ŀ
 ;   Terror end.                                                           
 ; 

 ; Ŀ
 ;   Herro - another error handler.                                        
 ; 
 (DEFUN HERRO (shk / pos entt enam sublst vall)
  (setq *error* esav)
  (if clay (setvar "clayer" clay))
  (if (/= shk "Function cancelled") (write-line shk))
 (princ))
 ; Ŀ
 ;   Herro end.                                                            
 ; 

 ; Ŀ
 ;   Hatche - hatch the last entity.                                       
 ; 
 (DEFUN HATCHE (/ *error* esav dimscl hasc)
  (setq esav *error*)
  (setq *error* herro)
 ; Ŀ
 ;   Get the scale, depending on which space we are in and other things.   
 ; 
  (if misps
      (setq dimscl (misps))
      (setq dimscl (getvar "dimscale")))
  (setq hasc (* dimscl 20))
  (if (zerop hasc) (setq hasc 20))
  (command "hatch" "dots" hasc "0" "l" "")
;  (command "change" "l" "" "p" "col" "red" "")
  (setq *error* esav)
 (princ))
 ; Ŀ
 ;   Hatche end.                                                           
 ; 

 ; Ŀ
 ;   Subroutine Crox - grdraw cross maker - used to put ortho lines on     
 ;   grdraw circles left by last C2 call when Zep exits.                   
 ; 
 (DEFUN CROX (pa radd widd /)
  (setq widd (+ radd widd))
  (setq colo -1)
  (grdraw (polar pa 0 radd) (polar pa 0 widd) colo)
  (grdraw (polar pa pi radd) (polar pa pi widd) colo)
  (grdraw (polar pa (* pi 0.5) radd) (polar pa (* pi 0.5) widd) colo)
  (grdraw (polar pa (* pi 1.5) radd) (polar pa (* pi 1.5) widd) colo)
 (princ))
 ; Ŀ
 ;   Crox end.                                                             
 ; 

 ; Ŀ
 ;   Subroutine C2 - grdraw dual circle maker.                             
 ; 
 (DEFUN C2 (pa radd widd / reps pa pa1 pa2 angg colo)
  (setq reps 32)
  (setq colo -1)
  (setq angg 0)
  (setq incr (/ pi (/ reps 2)))
  (setq pa1 (polar pa angg radd))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg radd))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
  (setq angg 0)
  (setq rad1 (+ radd widd))
  (setq pa1 (polar pa angg rad1))
  (repeat reps
          (setq angg (+ angg incr))
          (setq pa2 (polar pa angg rad1))
          (grdraw pa1 pa2 colo)
          (setq pa1 pa2))
 (princ))
 ; Ŀ
 ;   C2 end.                                                               
 ; 

 ; Ŀ
 ;   Subroutine Zep - cursor redefinition and point selection.             
 ; 
 (DEFUN ZEP (radd widd / pa pasav quitp)
  (setq esav *error*)
  (setq *error* terror)
  (prompt "Centre of arc: ")
  (while (and (setq pa (grread t))
              (null quitp))
         (if (= (car pa) 5)
             (progn
                  (setq pa (cadr pa))
                  (if (and pasav (not (equal pa pasav)))
                      (c2 pasav radd widd))
                  (if (not (equal pa pasav)) (c2 pa radd widd))
                  (setq pasav pa))
             (progn
                  (if pasav (crox pasav radd widd))
                  (setq quitp t))))
  (setq *error* esav)
 pa)
 ; Ŀ
 ;   Zep end.                                                              
 ; 

 ; Ŀ
 ;   Tray.                                                                 
 ; 
 (DEFUN C:TRAY ( / blip aa cc bb dd htp wdthp)
  (setvar "cmdecho" 0)
  (command "undo" "m")
  (setq blip (getvar "blipmode"))
  (setvar "blipmode" 0)
 ; Ŀ
 ;   Load Misps.lsp, which contains the ps/ms scaling subroutines.         
 ; 
  (if (or (null wasp) (null misps))
      (if (null (load "misps" ()))
          (prompt "\n** The File Misps.lsp Is Not Available. **\n")))
  (if (/= (type widd) 'REAL) (setq widd 300.0))
  (setq widp (getdist (strcat "Tray width <" (rtos widd 2 1) ">: ")))
  (if widp (setq widd widp))
  (if (/= (type radd) 'REAL) (setq radd 600.0))
  (setq radp (getdist (strcat "Tray bend radius <" (rtos radd 2 1) ">: ")))
  (if radp (setq radd radp))
  (grread t)
  (if (and (setq pa (cadr (zep radd widd)))
           (setq orth (getvar "orthomode"))
           (setvar "orthomode" 0)
           (setq pb (getpoint pa "\nQuadrant: ")))
      (progn
           (c2 pa radd widd)
           (crox pa radd widd)
           (setq pax (car pa))
           (setq pay (cadr pa))
           (setq pbx (car pb))
           (setq pby (cadr pb))
           (cond ((and (> pbx pax) (> pby pay))   ; upper right
                  (setq angx 0)
                  (setq angy (/ pi 2))
                  (setq incang 90))
                 ((and (> pbx pax) (< pby pay))   ; lower right
                  (setq angx 0)
                  (setq angy (* pi 1.5))
                  (setq incang -90))
                 ((and (< pbx pax) (< pby pay))   ; lower left
                  (setq angx pi)
                  (setq angy (* pi 1.5))
                  (setq incang 90))
                 ((and (< pbx pax) (> pby pay))   ; upper left
                  (setq angx pi)
                  (setq angy (/ pi 2))
                  (setq incang -90)))
           (setq ins1 (polar pa angx radd))
           (setq ins2 (polar pa angy radd))
           (setq out1 (polar pa angx (+ radd widd)))
           (setq out2 (polar pa angy (+ radd widd)))
           (setq clay (getvar "clayer"))
           (if (tblsearch "layer" "tray")
               (setvar "clayer" "tray")
               (command "layer" "m" "tray" "c" "2" "" ""))
           (command "pline" ins1 "arc" "ce" pa "a" incang
                                 "l" out2
                                 "arc" "ce" pa "a" (- incang) "l" "c")
           (hatche)
           (setvar "clayer" clay)))
  (setvar "blipmode" blip)
  (setvar "orthomode" orth)
 (princ))